define([
    'underscore',
    'marionette',
    'moment',
    
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',

    'text!modules/new-appointment-request/views/direct/preferred-date/templates/month-collapsible-expanded.html',
    'modules/new-appointment-request/views/direct/preferred-date/date-collapsible',
], function(
    _,
    Marionette,
    moment,
    
    TimeSlotsCollection,

    monthTemplate,
    DateCollapsibleView
) {
    'use strict';


    var ARIA_DATE_FORMAT = 'MMMM YYYY';

    // reduces rendering time with prerendered collapsible template;
    // given this.model (with month, monthName, and dates),
    // create this.collection filtered by date and show child views
    return Marionette.CompositeView.extend({
        attributes: {
            'data-role': 'collapsible',
            'data-enhanced': 'true',
        },
        className: 'ui-collapsible ui-collapsible-inset ui-collapsible-themed-content ui-corner-all',
        template: monthTemplate,
        childViewContainer: '.ui-collapsible-content',
        childView: DateCollapsibleView,
        initialize: function(options) {
            if (_.isUndefined(this.collection)) {
                this.collection = this.model.get('timeSlotsByDateCollection');
            }
        },
        templateContext: function() {
            var date = this.model.get('date');
            var ariaLabel = moment(date).format(ARIA_DATE_FORMAT);

            return {ariaLabel: ariaLabel};
        },
    });
});
